---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-x (bunx).md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **npmレジストリからのパッケージ情報取得の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/bunx_command.zig` - BunxCommand構造体とexec関数
- E-02: `src/cli/bunx_command.zig:8-136` - Options構造体定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `src/cli/bunx_command.zig:332-863` - exec関数メイン処理
- E-06: `src/cli/bunx_command.zig:178-181` - キャッシュ有効期限定数（24時間）
- E-07: `src/cli/bunx_command.zig:551-686` - 既存バイナリ検索処理
- E-08: `src/cli/bunx_command.zig:705-798` - インストール処理
- E-09: `src/cli/bunx_command.zig:361-374` - tsc→typescript変換
- E-10: `src/cli/bunx_command.zig:183-325` - getBinName関連関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bunxコマンドはパッケージのCLIバイナリを実行する | E-01, E-05 | ○ |
| C-02 | 未インストール時は自動的にインストールする | E-08 | ○ |
| C-03 | Options構造体にpackage_name、binary_name等が含まれる | E-02 | ○ |
| C-04 | Options.parse()でCLI引数を解析する | E-02 (行32-130) | ○ |
| C-05 | --no-installオプションでインストールをスキップできる | E-02 (no_install: bool) | ○ |
| C-06 | --packageオプションでパッケージを明示的に指定できる | E-02 (specified_package) | ○ |
| C-07 | キャッシュの有効期限は24時間（86400秒） | E-06 | ○ |
| C-08 | tscは自動的にtypescriptパッケージに変換される | E-09 | ○ |
| C-09 | bun.which()でPATHからバイナリを検索する | E-07 | ○ |
| C-10 | キャッシュ鮮度チェックを行う | E-07 (行578-617) | ○ |
| C-11 | 見つかった場合はRunCommand.runBinaryで実行 | E-07 (行620-630) | ○ |
| C-12 | bunxキャッシュディレクトリを作成する | E-08 (行705) | ○ |
| C-13 | 空のpackage.jsonを作成する | E-08 (行707-711) | ○ |
| C-14 | `bun add`を子プロセスとして実行する | E-08 (行713-798) | ○ |
| C-15 | 関連機能No.19,39,41が正しくマッピングされている | E-04 | ○ |
| C-16 | addCreatePrefix関数でcreate-プレフィックスを付加できる | E-01 (行138-176) | ○ |
| C-17 | getBinName関数でpackage.jsonからbin名を取得する | E-10 | ○ |
| C-18 | bunxキャッシュパスは`<temp_dir>/bunx-<uid>-<package>@<version>/`形式 | E-05 (行500-534) | ○ |
| C-19 | --silentオプションでインストール出力を抑制できる | E-02 (silent_install) | ○ |
| C-20 | --verboseオプションで詳細出力を有効化できる | E-02 (verbose_install) | ○ |
| C-21 | スコープ付きパッケージ（@org/pkg）をサポートする | E-01 (addCreatePrefix関数) | ○ |
| C-22 | npmレジストリからのパッケージ情報取得の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: npmレジストリからのパッケージ情報取得
  - bunx_command.zigではbun addを子プロセスとして呼び出すため、直接的なレジストリアクセスは行わない
  - 実際のレジストリアクセスはbun add (install.zig)で行われる
  - 候補：`src/install/npm.zig` / `src/install/registry.zig`

## 5) リスクフラグ（レビュー観点）
- 0: CLI引数解析処理 - 低リスク（ソースで確認済み）
- 0: 既存バイナリ検索処理 - 低リスク（ソースで確認済み）
- 0: キャッシュ管理 - 低リスク（ソースで確認済み）
- 0: インストール処理呼び出し - 低リスク（ソースで確認済み）
- 1: npmレジストリ連携詳細 - 中リスク（別ファイルの確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] C-01〜C-21の主張がソースコードと整合しているか確認
- [ ] キャッシュ有効期限（24時間）が適切か確認
- [ ] tsc→typescript変換ロジックが正しいか確認
- [ ] スコープ付きパッケージの処理が正しいか確認
- [ ] エラーメッセージ一覧が網羅的か確認
- [ ] Windows/macOS/Linuxでの動作差異を確認（キャッシュパス等）
